local song_title = GAMESTATE:GetCurrentSong():GetDisplayMainTitle()
local battler_file = {
	["Dishwasher Extraordinaire"] 	= "MadMatt",
	["Treadmill Simulator"]			= "Archi",
	["Cooler Than Blue"]			= "LittleMatt"
}

local bg_color = {
	["Dishwasher Extraordinaire"] 	= color("#aa3333"),
	["Treadmill Simulator"]			= color("#33aa33"),
	["Cooler Than Blue"]			= color("#3333aa")
}

local battler_name = {
	["Dishwasher Extraordinaire"] 	= "Mad Matt",
	["Treadmill Simulator"]			= "Archi",
	["Cooler Than Blue"]			= "Little Matt"
}


SRT.Dialog.Words = {
	{
		text= THEME:GetString("EnteringBattle","1") .. " " .. battler_name[song_title] .. "!\n" .. THEME:GetString("EnteringBattle","2") .. " - " .. song_title
	}
}

-- set the "defeated" flag for this gym leader to true now
SRT.Defeated[ battler_file[song_title] ] =  true


---------------------------------------------------------------------------------
-- Code for Spiral Transition below

local spiral_af = Def.ActorFrame{}
local iter = 0

local temp = {}

Spiral = function(_rows, _cols, r, d, inc)

	local op = 1

	for i=1,_rows*_cols do

		temp[#temp+1] = {r+inc, d+inc}
		iter = iter + 1

		if r == _cols and d == _rows then
			op = op * -1
		end

		if op > 0 then
			if r < _cols then
				r = r + (1 * op)
			elseif d < _rows then
				d = d + (1 * op)
			end
		else
			if r > 1 then
				r = r + (1 * op)
			elseif d > 1 then
				d = d + (1 * op)

				if r == 1 and d == 1 then
					Spiral(_rows-2,_cols-2,r,d, inc+1)
					break
				end
			end
		end
	end
end

local cols = 16
local rows = 9
Spiral(rows, cols, 1, 1, 0)

local width = _screen.w/cols
local height= _screen.h/rows

-- add quads in a spiraling pattern (calculated above) to this ActorFrame
for i, value in ipairs(temp) do

	spiral_af[#spiral_af+1] = Def.Quad{
		InitCommand=function(self)
			self:diffuse(0.1,0.1,0.1,0):zoomto(width, height):halign(1):valign(1)
				:xy( (value[1])*(width), (value[2])*(height) )
		end,
		OnCommand=function(self)
			self:sleep(i * (2.825/(rows*cols))):diffusealpha(1)
		end,
	}
end
---------------------------------------------------------------------------------

local t = Def.ActorFrame{
	OnCommand=function(self)
		SRT.Dialog.Speaker = nil
		SRT.Dialog.Box:sleep(4):queuecommand("Show"):queuecommand("ClearText"):queuecommand("UpdateText")
		self:sleep(13.25):queuecommand("FadeOut"):sleep(1.33):queuecommand("Transition")
	end,
	TransitionCommand=function(self)
		SRT.InputIsLocked = false
		SRT.DialogIsActive = false
		local topscreen = SCREENMAN:GetTopScreen()
		topscreen:SetNextScreenName("ScreenGameplay")
		topscreen:StartTransitioningScreen("SM_GoToNextScreen")
	end,

    Def.Sprite{
	   	OnCommand=function(self)

			local scale_factor = 1
			local ar = string.format( "%.3f" ,PREFSMAN:GetPreference("DisplayAspectRatio"))

			-- Surely there is a better way to do this...
			if ar == "1.778" then
				scale_factor = 1.333
			elseif ar == "1.600" then
				scale_factor = 1.2
			end

	   		self:Center()
	   			:SetTexture(SRT.ScreenshotTexture)
	   			:stretchto( 0,0, _screen.w,  _screen.h * scale_factor )
	   	end
	},


	-- spiral ActorFrame
	spiral_af,

	Def.Quad{
		InitCommand=function(self)
			self:FullScreen():Center():diffuse(0,0,0,0)
		end,
		OnCommand=function(self)
			self:sleep(2.825)
			self:accelerate(1):diffuse( bg_color[song_title] )
		end
	},



	Def.ActorFrame{
		InitCommand=function(self) self:Center():diffusealpha(0) end,
		OnCommand=function(self) self:sleep(3):accelerate(1):diffusealpha(1) end,

		LoadActor("swoosh.png")..{
			InitCommand=function(self)
				self:zoomto(SRT.TileData.Width.Pixels, SRT.TileData.Height.Pixels)
					:customtexturerect(0,0,1,1):texcoordvelocity(2.25,0)
			end
		},


		LoadActor( battler_file[song_title] )..{
			InitCommand=function(self) self:zoom(0.225):y(12) end
		},
	},


	-- dialog box
	LoadActor(THEME:GetPathB("","_DialogBox.lua")),

	Def.Quad{
		InitCommand=function(self) self:FullScreen():Center():diffuse(0,0,0,0) end,
		FadeOutCommand=function(self) self:accelerate(1):diffusealpha(1) end
	}
}

return t